<?php
$totalSiswa = 0;
$persentaseHadir = 0;

if (isset($jumlahKehadiranSiswa)) {

    $hadir = $jumlahKehadiranSiswa['hadir'] ?? 0;
    $sakit = $jumlahKehadiranSiswa['sakit'] ?? 0;
    $izin  = $jumlahKehadiranSiswa['izin'] ?? 0;
    $alfa  = $jumlahKehadiranSiswa['alfa'] ?? 0;

    $totalSiswa = $hadir + $sakit + $izin + $alfa;

    if ($totalSiswa > 0) {
        $persentaseHadir = round(($hadir / $totalSiswa) * 100, 1);
    }
}
?>


<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<style>
/* ========================================================= */
/* 🎨 BRANDING SEKOLAH – GANTI WARNA DI SINI SAJA */
/* ========================================================= */
:root{
    --brand-primary: #0d6efd;   /* Biru sekolah */
    --brand-secondary: #198754; /* Hijau sekolah */
    --brand-accent: #9843e7;    /* Kuning aksen */
}

/* CARD HEADER */
.bg-brand-primary{
    background: linear-gradient(135deg, var(--brand-primary), #084298);
}

/* CARD INFORMASI (CARD KE-2) */
.bg-brand-secondary{
    background: linear-gradient(135deg, var(--brand-secondary), #0f5132);
}

/* CARD KE-3 */
.bg-brand-third{
    background: linear-gradient(135deg, var(--brand-accent), #682853);
}

/* CARD KE-4 */
.bg-brand-fourth{
    background: linear-gradient(135deg, #6f42c1, #4e2a84);
}

/* ICON CIRCLE */
.icon-circle{
    width:60px;
    height:60px;
    border-radius:50%;
    display:flex;
    align-items:center;
    justify-content:center;
    margin:auto;
    font-size:28px;
    color:#fff;
}

/* HOVER CARD */
.hover-card{
    transition: all .3s ease;
}
.hover-card:hover{
    transform: translateY(-6px);
    box-shadow: 0 12px 25px rgba(0,0,0,.15);
}

/* INFO LIST SPACING */
.info-list div {
    margin-bottom: 0.5rem; /* jarak antar baris */
}

/* ========================================================= */
/* ANIMASI FADE-IN + SLIDE UP */
@keyframes fadeSlideUp {
    0% { opacity: 0; transform: translateY(20px); }
    100% { opacity: 1; transform: translateY(0); }
}
.animated-card {
    animation: fadeSlideUp 0.8s ease forwards;
}
.animated-title { animation-delay: 0.2s; }
.animated-subtitle { animation-delay: 0.4s; }
.animated-icon { animation-delay: 0.6s; }

/* FONT TEBAL */
.fw-extra-bold {
    font-weight: 900 !important;
}

/* ============================= */
/* CARD STATISTIK BERWARNA */
/* ============================= */

.stat-card{
    border-radius: 16px;
    color: #fff;
    transition: all .3s ease;
    overflow: hidden;
}

.stat-card:hover{
    transform: translateY(-6px);
    box-shadow: 0 15px 30px rgba(0,0,0,.2);
}

.stat-card .card-body{
    padding: 1.5rem 1rem;
}

.stat-icon{
    font-size: 40px;
    opacity: .9;
    margin-bottom: 10px;
}

.stat-number{
    font-size: 1.8rem;
    font-weight: 900;
}

/* Gradient Warna */
.bg-total{
    background: linear-gradient(135deg,#4e73df,#224abe);
}

.bg-hadir{
    background: linear-gradient(135deg,#1cc88a,#13855c);
}

.bg-sakit{
    background: linear-gradient(135deg,#f6c23e,#dda20a);
}

.bg-izin{
    background: linear-gradient(135deg,#36b9cc,#258391);
}

.bg-alpa{
    background: linear-gradient(135deg,#e74a3b,#be2617);
}

</style>

<div class="content">
<div class="container-fluid">

    <!-- ========================================================= -->
    <!-- 🔰 HEADER / CARD PERTAMA -->
    <!-- ========================================================= -->
    <div class="row mb-2">
        <div class="col-12">
            <div class="card bg-brand-primary text-white shadow-lg hover-card animated-card">
                <!-- <div class="card bg-brand-third text-white shadow-lg"> -->

                <div class="card-body d-flex flex-column justify-content-center align-items-center text-center" style="min-height:200px;">
                    <div class="text-content">
                        <h3 class="fw-extra-bold mb-2 animated-title" style="font-size:2rem;">
                            📲 Scan QR Kehadiran 📲
                        </h3>
                        <p class="mb-0 opacity-75 animated-subtitle" style="font-size:1.2rem;">
                            Sistem Absensi Digital SMAN1 Cikatomas
                        </p>
                    </div>
                    <i class="material-icons d-block animated-icon" style="font-size:64px;opacity:.3;margin-top:15px;">
                        qr_code_scanner
                    </i>
                </div>
            </div>
        </div>
    </div>

    <!-- ========================================================= -->
    <!-- 🔰 CARD KEDUA (WARNA BERBEDA) -->
    <!-- ========================================================= -->
    <div class="row mb-1">
        <div class="col-12">
            <div class="card bg-brand-secondary text-white shadow-lg hover-card animated-card" style="animation-delay: 0.2s;">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="fw-extra-bold mb-1" style="font-size:1.8rem;">
                            📋 Informasi Sistem Absensi
                        </h4>
                        <div class="opacity-75 info-list" style="font-size:1rem; line-height:1.6;">
                            <div>✅ Scan QR untuk mencatat kehadiran siswa</div>
                            <div>⏰ Presensi otomatis sesuai waktu yang sudah di seting admin</div>
                            <div>📊 Data kehadiran tersimpan real-time</div>
                            <div>🔒 Aman & terintegrasi dengan sistem sekolah</div>
                        </div>
                    </div>
                    <i class="material-icons d-none d-md-block" style="font-size:64px;opacity:.3;">
                        info
                    </i>
                </div>
            </div>
        </div>
    </div>




<!-- ========================================================= -->
<!-- 📈 PERSENTASE KEHADIRAN (HORIZONTAL) -->
<!-- ========================================================= -->
<div class="row mb-3">
    <div class="col-12">
        <div class="card bg-brand-third text-white shadow-lg hover-card animated-card">
            <div class="card-body d-flex justify-content-between align-items-center"
                 style="min-height:160px;">

                <!-- TEXT KIRI -->
                <div>
                    <h3 class="fw-extra-bold mb-2 animated-title" style="font-size:1.8rem;">
                        📈 Persentase Kehadiran Hari Ini
                    </h3>

                    <h1 class="fw-extra-bold mb-1" style="font-size:3rem;">
                        <?= $persentaseHadir; ?>%
                    </h1>

                    <p class="mb-0 opacity-75 animated-subtitle">
                        <?= $hadir; ?> dari <?= $totalSiswa; ?> siswa hadir hari ini
                    </p>
                </div>

                <!-- ICON KANAN -->
                <i class="material-icons d-none d-md-block animated-icon"
                   style="font-size:90px; opacity:.25;">
                    trending_up
                </i>

            </div>
        </div>
    </div>
</div>





<!-- ========================================================= -->
<!-- 📊 CARD STATISTIK KEHADIRAN SISWA -->
<!-- ========================================================= -->
<div class="row mt-4 g-3">

    <!-- Jumlah Siswa -->
    <div class="col-lg col-md-4 col-6">
        <div class="card stat-card bg-total text-center border-0">
            <div class="card-body">
                <i class="material-icons stat-icon">groups</i>
                <h6 class="fw-bold">Jumlah Siswa</h6>
                <div class="stat-number">
                    <?= $jumlahKehadiranSiswa['hadir'] 
                       + $jumlahKehadiranSiswa['sakit'] 
                       + $jumlahKehadiranSiswa['izin'] 
                       + $jumlahKehadiranSiswa['alfa']; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Hadir -->
    <div class="col-lg col-md-4 col-6">
        <div class="card stat-card bg-hadir text-center border-0">
            <div class="card-body">
                <i class="material-icons stat-icon">how_to_reg</i>
                <h6 class="fw-bold">Hadir</h6>
                <div class="stat-number">
                    <?= $jumlahKehadiranSiswa['hadir']; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Sakit -->
    <div class="col-lg col-md-4 col-6">
        <div class="card stat-card bg-sakit text-center border-0">
            <div class="card-body">
                <i class="material-icons stat-icon">medical_services</i>
                <h6 class="fw-bold">Sakit</h6>
                <div class="stat-number">
                    <?= $jumlahKehadiranSiswa['sakit']; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Izin -->
    <div class="col-lg col-md-4 col-6">
        <div class="card stat-card bg-izin text-center border-0">
            <div class="card-body">
                <i class="material-icons stat-icon">assignment_turned_in</i>
                <h6 class="fw-bold">Izin</h6>
                <div class="stat-number">
                    <?= $jumlahKehadiranSiswa['izin']; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Alpa -->
    <div class="col-lg col-md-4 col-6">
        <div class="card stat-card bg-alpa text-center border-0">
            <div class="card-body">
                <i class="material-icons stat-icon">cancel</i>
                <h6 class="fw-bold">Alpa</h6>
                <div class="stat-number">
                    <?= $jumlahKehadiranSiswa['alfa']; ?>
                </div>
            </div>
        </div>
    </div>

</div>











</div>
</div>

<?= $this->endSection() ?>
